#import <Cocoa/Cocoa.h>

//
// Thread-safe NSArray wrapper
// 
// (all operations including the 'loops' are atomic)
//

@interface SYQueue : NSObject 
{
@protected
    volatile NSMutableArray  * volatile queue;
}

- (void)enqueue:(id)obj;
- (id)dequeue;
- (id)front;
- (NSUInteger)count;
- (void)makeObjectsPerformSelector:(SEL)aSelector;
- (void)makeObjectsPerformSelector:(SEL)aSelector withObject:(id)argument;
- (void)enumerateObjectsWithTarget:(id)aTarget selector:(SEL)aSelector;
- (void)enumerateObjectsWithTarget:(id)aTarget selector:(SEL)aSelector object:(id)anArg;
- (void)removeAllObjects;
@end
